import matplotlib.pyplot as plt
import numpy as np; np.random.seed(0); np.random.seed(0)


# ===================
# Part 2: Data Preparation
# ===================
# Prepare data
x_solar = np.array([50, 55, 60, 65, 70])  # Installed capacity in GW
y_solar = np.array([18, 20, 22, 24, 27])  # Efficiency percentage
sizes_solar = np.random.randint(100, 300, size=len(x_solar))

x_wind = np.array([45, 50, 55, 60, 65])
y_wind = np.array([25, 38, 29, 31, 33])
sizes_wind = np.random.randint(100, 300, size=len(x_wind))

x_hydro = np.array([60, 65, 70, 75, 80])
y_hydro = np.array([35, 30, 39, 32, 43])
sizes_hydro = np.random.randint(100, 300, size=len(x_hydro))

labels = ["Solar Power", "Wind Power", "Hydropower"]
titles = ["Solar Power Performance", "Wind Power Performance", "Hydropower Performance"]
xlabel = "Installed Capacity (GW)"
ylabel = "Efficiency (%)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots with 1 row and 3 columns
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Define a color gradient
colors = ["cyan", "magenta", "lime"]

# Plot each dataset in a separate subplot with gradient colors
for ax, x, y, sizes, color, label, title in zip(
    axs,
    [x_solar, x_wind, x_hydro],
    [y_solar, y_wind, y_hydro],
    [sizes_solar, sizes_wind, sizes_hydro],
    colors,
    labels,
    titles,
):
    scatter = ax.scatter(
        x,
        y,
        s=sizes,
        c=np.linspace(0.1, 1, len(x)),
        cmap="summer",
        alpha=0.6,
        label=label,
    )
    ax.plot(x, y, linestyle="-", color=color, alpha=0.5)  # Use lighter alpha for lines
    ax.set_title(title)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better presentation
plt.tight_layout()
# Show the plot
plt.savefig('scatter_25.pdf', bbox_inches='tight')
