import matplotlib.pyplot as plt
import matplotlib.lines as mlines

# ===================
# Part 2: Data Preparation
# ===================
# Sample data for the plot; replace with actual data.
methods = ["Agile", "Scrum", "Kanban", "Waterfall", "Lean", "XP"]
colors = [
    "black",
    "green",
    "red",
    "orange",
    "purple",
    "brown",
]  # Colors for each method.

# Data for the subplots; each list within quality_data and speed_data corresponds to a subplot.
quality_data = [[6.2, 7.9, 6.7, 6.9, 7.6, 7.3], [7.8, 8.1, 8.5, 8.9, 8.6, 8.3]]

speed_data = [[30, 45, 55, 25, 40, 35], [50, 60, 70, 75, 65, 72]]

# Sizes for the scatter points, shared across both subplots.
scatter_sizes = [60, 110, 90, 140, 180, 130]

# Legend labels for the subplots.
ax1_legend_names = ["Small", "Medium", "Large", "X-Large"]
ax2_legend_names = ["<100", "100-200", "200-300", ">300"]
ax1_legend_title = "Project Size"
ax2_legend_title = "LOC (k)"
xlabel = "Code Quality"
ylabel = "Development Speed (days)"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x1 grid of subplots with a specified figure size.
fig, axs = plt.subplots(2, 1, figsize=(6, 6))

# Populate the subplots with scatter points and add text labels.
for idx, ax in enumerate(axs):
    for method, qual, speed, size, color in zip(
        methods, quality_data[idx], speed_data[idx], scatter_sizes, colors
    ):
        ax.scatter(qual, speed, s=size, color=color, alpha=0.5)  # Plot the scatter points.
        ax.text(
            qual, speed + 1, method, fontsize=9
        )  # Add text labels above scatter points.

    ax.set_xlabel(xlabel)  # X-axis label.
    ax.set_ylabel(ylabel)  # Y-axis label.

# Adjust the x and y limits and ticks for the subplots.
axs[0].set_xlim(6.0, 9.0)
axs[0].set_ylim(20, 60)
axs[0].set_xticks([6.5, 7.0, 7.5, 8.0, 8.5])
axs[0].set_yticks([20, 30, 40, 50, 60])
axs[1].set_xlim(7.5, 9.5)
axs[1].set_ylim(40, 80)
axs[1].set_xticks([8.0, 8.5, 9.0, 9.5])
axs[1].set_yticks([40, 50, 60, 70, 80])


size_legend_handles = [60, 110, 140, 180]  # Sizes for the legend handles.

# Create custom legend handles for the first subplot.
ax1_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax1_legend_names)
]

# Create custom legend handles for the second subplot.
ax2_legend_handles = [
    mlines.Line2D(
        [],
        [],
        color="#8080f7",
        marker="o",
        linestyle="None",
        markersize=(size**0.5) * 0.8,
        label=name,
    )  # Adjust marker size here.
    for size, name in zip(size_legend_handles, ax2_legend_names)
]

# Add legends to the subplots.
axs[0].legend(
    handles=ax1_legend_handles,
    loc="lower right",
    title=ax1_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)
axs[1].legend(
    handles=ax2_legend_handles,
    loc="lower right",
    title=ax2_legend_title,
    labelspacing=2.0,
    edgecolor="black",
)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig('scatter_3.pdf', bbox_inches='tight')
