
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
# Data for DE plot (transportation domain)
de_speed = [55, 60, 50, 45, 65]
de_fuel_efficiency = [25, 24, 28, 30, 26]
de_labels = ["Bus", "Car", "Bike", "Train", "Plane"]

# Data for PJM plot (transportation domain)
pjm_speed = [60, 55, 58, 62, 65]
pjm_fuel_efficiency = [23, 25, 22, 28, 21]
pjm_labels = ["Bus", "Car", "Bike", "Train", "Plane"]

# Extracted variables for plot configuration (transportation domain)
de_title = "DE - Transportation Metrics"
de_xlabel = "Speed (km/h)"
de_ylabel = "Fuel Efficiency (km/l)"
de_xlim = (40, 70)
de_xticks = [40, 45, 50, 55, 60, 65, 70]
de_ylim = (20, 32)
de_yticks = [20, 22, 24, 26, 28, 30, 32]

pjm_title = "PJM - Transportation Metrics"
pjm_xlabel = "Speed (km/h)"
pjm_ylabel = "Fuel Efficiency (km/l)"
pjm_xlim = (50, 70)
pjm_xticks = [50, 55, 60, 65, 70]
pjm_ylim = (20, 30)
pjm_yticks = [20, 22, 24, 26, 28, 30]


de_colors = ["#a0cf63", "#a0cf63", "#56bcba", "#e69c55", "#c43932"]
pjm_colors = ["#a0cf63", "#a0cf63", "#56bcba", "#e69c55", "#c43932"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 10))

# DE plot
for x, y, color, label in zip(de_speed, de_fuel_efficiency, de_colors, de_labels):
    if label == "Bus":
        ax1.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax1.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax1.set_title(de_title)
ax1.set_xlabel(de_xlabel)
ax1.set_ylabel(de_ylabel)
ax1.set_xlim(de_xlim)  # Adjust x-axis range
ax1.set_xticks(de_xticks)
ax1.set_ylim(de_ylim)  # Adjust y-axis range
ax1.set_yticks(de_yticks)
ax1.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

# PJM plot
for x, y, color, label in zip(pjm_speed, pjm_fuel_efficiency, pjm_colors, pjm_labels):
    if label == "Bus":
        ax2.scatter(
            x, y, label=label, facecolors="none", edgecolors=color, s=200, linewidths=4
        )
    else:
        ax2.scatter(x, y, label=label, color=color, s=200)  # Increase marker size
ax2.set_title(pjm_title)
ax2.set_xlabel(pjm_xlabel)
ax2.set_ylabel(pjm_ylabel)
ax2.set_xlim(pjm_xlim)  # Adjust x-axis range
ax2.set_xticks(pjm_xticks)
ax2.set_ylim(pjm_ylim)  # Adjust y-axis range
ax2.set_yticks(pjm_yticks)
ax2.grid(True, linestyle="--", linewidth=0.5, color="black")  # Add grid

legend_elements = [
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Bus",
        markersize=10,
        markerfacecolor="none",
        markeredgewidth=4,
        markeredgecolor="#a0cf63",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Car",
        markersize=10,
        markerfacecolor="#a0cf63",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Bike",
        markersize=10,
        markerfacecolor="#56bcba",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Train",
        markersize=10,
        markerfacecolor="#e69c55",
    ),
    Line2D(
        [0],
        [0],
        marker="o",
        color="w",
        label="Plane",
        markersize=10,
        markerfacecolor="#c43932",
    ),
]

# Create the legend using the custom handles
fig.legend(
    handles=legend_elements,
    loc="lower center",
    ncol=5,
    borderaxespad=0.05,
    frameon=False,
)

# Adjust the layout to make room for the legend
plt.subplots_adjust(bottom=0.1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig('scatter_9.pdf', bbox_inches='tight')
