import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
sizes = [28.45, 22.35, 16.75, 12.80, 9.90, 5.75, 3.60, 0.40]
labels = [
    "Uber\n28.45%",
    "Lyft\n22.35%",
    "Public Transport\n16.75%",
    "Bicycles\n12.80%",
    "Electric Scooters\n9.90%",
    "Car Rentals\n5.75%",
    "Walking\n3.60%",
    "Other\n0.40%",
]
colors = [
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
    "#8c564b",
    "#e377c2",
    "#7f7f7f",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=sizes, label=labels, color=colors, alpha=0.7, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_1.pdf', bbox_inches='tight')
