# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [0.24, 0.10, 0.15, 0.20, 0.13, 0.15]
brand_labels = [
    "Rolex\n24%",
    "Omega\n10%",
    "Tag Heuer\n15%",
    "Seiko\n20%",
    "Casio\n13%",
    "Others\n15%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8ecae6", "#219ebc", "#023047", "#ffb703", "#fb8500", "#8e4a49"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=colors,
    text_kwargs={"fontsize": 18, "color": "white"},
    pad=0.25,
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Show plot
plt.savefig('tree_11.pdf', bbox_inches='tight')