# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [38, 24, 16, 9, 7, 6]
brand_labels = [
    "Burberry\n38%",
    "Canada Goose\n24%",
    "Moncler\n16%",
    "The North Face\n9%",
    "Patagonia\n7%",
    "Columbia\n6%",
]
plot_title = 'Market Share of Leading Coat Brands'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
brand_colors = ["#FFDDC1", "#FDA2A8", "#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9"]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=brand_colors,
    alpha=0.7,
    text_kwargs={"fontsize": 18, "weight": 'bold'},
    ec="black",
)

# Add a title
plt.title(plot_title, fontsize=22, weight='bold')

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig('tree_14.pdf', bbox_inches='tight')