# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
investment_distribution = [28, 25, 18, 12, 10, 7]
labels = ["Electric Vehicles", "Renewable Energy", "Smart Grids", "Energy Storage", "Hydrogen Fuel", "Carbon Capture"]
plot_title = "Energy Sector Investment Distribution"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4A90E2", "#50E3C2", "#B8E986", "#7ED321", "#417505", "#BD10E0"]
# Create a figure with the specified size
fig = plt.figure(figsize=(10, 6))

# Create a treemap
squarify.plot(
    sizes=investment_distribution,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 12, "color": "white"},
    ec="black",  # edge color
)

# Add title
plt.title(plot_title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_16.pdf', bbox_inches='tight')