# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [30, 28, 20, 10, 7, 5]
brand_labels = [
    "Lenovo\n30%",
    "HP\n28%",
    "Dell\n20%",
    "Apple\n10%",
    "Acer\n7%",
    "Asus\n5%",
]
plot_title = "Global Market Share of Leading Computer Brands"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
brand_colors = ["#8B4513", "#FFD700", "#D2B48C", "#90EE90", "#FFDAB9", "#FFDEAD"]
# Create a figure with the specified size
fig = plt.figure(figsize=(8, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=brand_labels,
    color=brand_colors,
    alpha=0.85,
    text_kwargs={"fontsize": 14, "color": "black"},
    pad=True,
    ec="white"
)

# Add a title
plt.title(plot_title, fontsize=18)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_19.pdf', bbox_inches='tight')