import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [35, 23, 17, 10, 8, 7]
labels = ["Tencent - 35%", "Alibaba - 23%", "Baidu - 17%", "JD.com - 10%", "NetEase - 8%", "Others - 7%"]
colors = ["#FF6347", "#4682B4", "#32CD32", "#FFD700", "#FF69B4", "#8A2BE2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with the specified size
fig = plt.figure(figsize=(6, 4))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=labels,
    color=colors,
    alpha=0.7,
    text_kwargs={"fontsize": 12, "color": "black"},
    ec="black",
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig('tree_4.pdf', bbox_inches='tight')
