# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# Data
market_shares = [28.0, 22.0, 18.0, 12.0, 9.0, 6.0, 3.5, 1.5]
company_labels = [
    "Tesla\n28.0%",
    "NVIDIA\n22.0%",
    "Meta\n18.0%",
    "Alibaba\n12.0%",
    "Tencent\n9.0%",
    "Oracle\n6.0%",
    "Cisco\n3.5%",
    "Spotify\n1.5%",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = [
    "#8c510a",
    "#d8b365",
    "#f6e8c3",
    "#c7eae5",
    "#5ab4ac",
    "#01665e",
    "#c2a5cf",
    "#762a83",
]
# Create a figure with the specified size
fig = plt.figure(figsize=(12, 8))

# Create a treemap
squarify.plot(
    sizes=market_shares, label=company_labels, color=colors, alpha=0.8, text_kwargs={"fontsize": 18}
)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout and save to file
plt.tight_layout()
plt.savefig("tree_6.pdf", bbox_inches="tight")