# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import squarify

# ===================
# Part 2: Data Preparation
# ===================
# New data for home appliance market share
market_shares = [0.30, 0.25, 0.20, 0.12, 0.08, 0.05]
company_labels = [
    "LG\n30%",
    "Samsung\n25%",
    "Whirlpool\n20%",
    "Bosch\n12%",
    "Panasonic\n8%",
    "Others\n5%",
]
title = "Home Appliance Market Share"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#003f5c", "#2f4b7c", "#665191", "#a05195", "#d45087", "#f95d6a"]
# Create a figure with the specified size
fig = plt.figure(figsize=(14, 10))

# Create a treemap
squarify.plot(
    sizes=market_shares,
    label=company_labels,
    color=colors,
    text_kwargs={"fontsize": 20, "color": "white"},
    pad=0.3,
)

# Add a title
plt.title(title, fontsize=24)

# Remove axes
plt.axis("off")

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot
plt.savefig("tree_8.pdf", bbox_inches="tight")