
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate new data for body posture analysis
# data for the first posture
posture1 = np.array(
    [
        [0.1, 0.3, 0.2, 0.4, 0.3, 0.2, 0.4, 0.3, 0.5, 0.4, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0],
        [0.5, 0.6, 0.55, 0.65, 0.5, 0.4, 0.45, 0.5, 0.6, 0.55, 0.65, 0.7, 0.75, 0.8, 0.7, 0.65, 0.6],
        [0.7, 0.8, 0.75, 0.8, 0.85, 0.9, 0.85, 1.0, 1.1, 1.05, 1.15, 1.1, 1.0, 0.95, 0.9, 0.85, 0.8]
    ]
)

# data for the second posture
posture2 = np.array(
    [
        [0.2, 0.4, 0.3, 0.5, 0.4, 0.3, 0.6, 0.5, 0.4, 0.3, 0.5, 0.7, 0.5, 0.4, 0.2, 0.1, 0.0],
        [0.4, 0.5, 0.45, 0.55, 0.5, 0.4, 0.35, 0.3, 0.4, 0.35, 0.55, 0.6, 0.65, 0.7, 0.6, 0.55, 0.5],
        [0.6, 0.7, 0.65, 0.7, 0.75, 0.8, 0.75, 0.9, 1.0, 0.95, 1.05, 1.0, 0.9, 0.85, 0.8, 0.75, 0.7]
    ]
)

labels = ["Posture 1", "Posture 2"]
xlabel = "X Axis"
ylabel = "Y Axis"
zlabel = "Z Axis"
title = "3D Body Posture Analysis"
legendlabels = ["Posture 1", "Posture 2"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data for the first posture
x1 = posture1[0]
y1 = posture1[1]
z1 = posture1[2]

# data for the second posture
x2 = posture2[0]
y2 = posture2[1]
z2 = posture2[2]

fig, ax = plt.subplots(figsize=(10, 10), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.2])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)
ax.view_init(elev=20.0, azim=40)
ax.dist = 8

# 3D scatter for first posture
ax.scatter3D(x1, y1, z1, color="mediumseagreen", label=labels[0], s=50)

# draw the body for first posture
# left leg
ax.plot(x1[0:4], y1[0:4], z1[0:4], ls="--", color="green", linewidth=2)
# right leg
ax.plot(
    np.hstack((x1[0], x1[4:7])),
    np.hstack((y1[0], y1[4:7])),
    np.hstack((z1[0], z1[4:7])),
    ls="--",
    color="green",
    linewidth=2,
)
# spine
ax.plot(
    np.hstack((x1[0], x1[7:11])),
    np.hstack((y1[0], y1[7:11])),
    np.hstack((z1[0], z1[7:11])),
    ls="--",
    color="green",
    linewidth=2,
)
# right arm
ax.plot(
    np.hstack((x1[8], x1[11:14])),
    np.hstack((y1[8], y1[11:14])),
    np.hstack((z1[8], z1[11:14])),
    ls="--",
    color="green",
    linewidth=2,
)
# left arm
ax.plot(
    np.hstack((x1[8], x1[14:])),
    np.hstack((y1[8], y1[14:])),
    np.hstack((z1[8], z1[14:])),
    ls="--",
    color="green",
    linewidth=2,
)

# 3D scatter for second posture
ax.scatter3D(x2, y2, z2, color="mediumslateblue", label=labels[1], s=50)

# draw the body for second posture
# left leg
ax.plot(x2[0:4], y2[0:4], z2[0:4], ls="--", color="blue", linewidth=2)
# right leg
ax.plot(
    np.hstack((x2[0], x2[4:7])),
    np.hstack((y2[0], y2[4:7])),
    np.hstack((z2[0], z2[4:7])),
    ls="--",
    color="blue",
    linewidth=2,
)
# spine
ax.plot(
    np.hstack((x2[0], x2[7:11])),
    np.hstack((y2[0], y2[7:11])),
    np.hstack((z2[0], z2[7:11])),
    ls="--",
    color="blue",
    linewidth=2,
)
# right arm
ax.plot(
    np.hstack((x2[8], x2[11:14])),
    np.hstack((y2[8], y2[11:14])),
    np.hstack((z2[8], z2[11:14])),
    ls="--",
    color="blue",
    linewidth=2,
)
# left arm
ax.plot(
    np.hstack((x2[8], x2[14:])),
    np.hstack((y2[8], y2[14:])),
    np.hstack((z2[8], z2[14:])),
    ls="--",
    color="blue",
    linewidth=2,
)

plt.legend(title="Postures")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_21.pdf", bbox_inches="tight")
