
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# raw data
# data representing component positions in a tech device
component1 = np.array(
    [
        [0.1, 0.2, 0.15, 0.35, 0.5, 0.45, 0.55, 0.5, 0.44, 0.35, 0.3, 0.2, 0.15, 0.1, 0.15, 0.25, 0.35],
        [0.05, 0.15, 0.1, 0.25, 0.4, 0.35, 0.45, 0.4, 0.35, 0.25, 0.2, 0.1, 0.05, 0.0, 0.1, 0.2, 0.3],
        [0.3, 0.35, 0.2, 0.15, 0.5, 0.25, 0.15, 0.6, 0.8, 0.85, 1.0, 0.75, 0.55, 0.4, 0.65, 0.55, 0.4],
    ]
)

component2 = np.array(
    [
        [0.6, 0.55, 0.52, 0.65, 0.7, 0.65, 0.68, 0.7, 0.65, 0.52, 0.58, 0.73, 0.78, 0.75, 0.55, 0.45, 0.52],
        [0.25, 0.35, 0.3, 0.45, 0.6, 0.55, 0.65, 0.6, 0.55, 0.45, 0.4, 0.3, 0.25, 0.2, 0.4, 0.5, 0.45],
        [0.5, 0.55, 0.4, 0.35, 0.7, 0.45, 0.35, 0.75, 0.95, 1.0, 1.2, 1.0, 0.85, 0.7, 1.05, 0.9, 0.75],
    ]
)

labels = ["Sensor Array", "Processor Module"]
xlabel = "X-Axis (Position)"
ylabel = "Y-Axis (Position)"
zlabel = "Z-Axis (Height)"
title = "3D Component Positioning in Tech Device"
legendlabels = ["Sensor Array", "Processor Module"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# data for the first component group (Sensors)
x1 = component1[0]
y1 = component1[1]
z1 = component1[2]

# data for the second component group (Processors)
x2 = component2[0]
y2 = component2[1]
z2 = component2[2]

fig, ax = plt.subplots(figsize=(10, 10), subplot_kw={"projection": "3d"})

radius = 1
ax.set_xlim3d([0, radius])
ax.set_ylim3d([0, radius])
ax.set_zlim3d([0, radius * 1.5])
ax.set_title(title, fontsize=16)
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.view_init(elev=25.0, azim=60)
ax.dist = 7

# 3D scatter
ax.scatter3D(x1, y1, z1, color="#1f77b4", label=labels[0], marker='o', s=100, alpha=0.7)
ax.scatter3D(x2, y2, z2, color="#ff7f0e", label=labels[1], marker='^', s=100, alpha=0.7)

# draw lines for components
# Sensor Array lines
ax.plot(x1[:5], y1[:5], z1[:5], ls="--", color="#1f77b4", linewidth=2)
ax.plot(x1[5:], y1[5:], z1[5:], ls=":", color="#1f77b4", linewidth=2)

# Processor Module lines
ax.plot(x2[:5], y2[:5], z2[:5], ls="--", color="#ff7f0e", linewidth=2)
ax.plot(x2[5:], y2[5:], z2[5:], ls=":", color="#ff7f0e", linewidth=2)

plt.legend(legendlabels, fontsize=12, loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_23.pdf", bbox_inches="tight")
