
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(42)

subjects = np.array(
    [
        [1, 2, 3, 4, 5, 6],
        [1, 2, 3, 4, 5, 6],
        [1, 2, 3, 4, 5, 6],
        [1, 2, 3, 4, 5, 6],
        [1, 2, 3, 4, 5, 6],
        [1, 2, 3, 4, 5, 6],
    ]
)
study_hours = np.array(
    [
        [5, 5, 5, 5, 5, 5],
        [10, 10, 10, 10, 10, 10],
        [15, 15, 15, 15, 15, 15],
        [20, 20, 20, 20, 20, 20],
        [25, 25, 25, 25, 25, 25],
        [30, 30, 30, 30, 30, 30],
    ]
)
grades = np.array(
    [
        [70, 72, 75, 78, 80, 82],
        [74, 76, 79, 82, 84, 85],
        [76, 78, 81, 84, 86, 88],
        [78, 80, 83, 86, 88, 90],
        [80, 82, 85, 88, 90, 92],
        [82, 84, 87, 90, 92, 94],
    ]
)

xlabel = "Subjects"
ylabel = "Study Hours per Week"
zlabel = "Grades (%)"
title = "Student Performance Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig = plt.figure(figsize=(10, 6))  # Adjusting figure size to match original image's dimensions
ax = fig.add_subplot(111, projection="3d")

# Plot a 3D surface
surf = ax.plot_surface(subjects, study_hours, grades, cmap="viridis", edgecolor="black")

# Labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title, y=1.00)
ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
# Saving the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_27.pdf", bbox_inches="tight")
