
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# Data for plotting
import numpy as np

np.random.seed(0)

months = np.array(
    [
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
        [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12],
    ]
)
years = np.array(
    [
        [2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000],
        [2001, 2001, 2001, 2001, 2001, 2001, 2001, 2001, 2001, 2001, 2001, 2001],
        [2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 2002],
        [2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 2003],
        [2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004],
        [2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005, 2005],
    ]
)
temperatures = np.array(
    [
        [30.5, 32.1, 35.2, 38.1, 40.0, 39.8, 37.2, 33.4, 29.9, 27.5, 25.2, 23.3],
        [30.7, 32.3, 35.4, 38.3, 40.2, 40.0, 37.4, 33.6, 30.1, 27.7, 25.4, 23.5],
        [31.0, 32.6, 35.7, 38.6, 40.5, 40.3, 37.7, 33.9, 30.4, 28.0, 25.7, 23.8],
        [31.2, 32.8, 35.9, 38.8, 40.7, 40.5, 37.9, 34.1, 30.6, 28.2, 25.9, 24.0],
        [31.5, 33.1, 36.2, 39.1, 41.0, 40.8, 38.2, 34.4, 30.9, 28.5, 26.2, 24.3],
        [31.7, 33.3, 36.4, 39.3, 41.2, 41.0, 38.4, 34.6, 31.1, 28.7, 26.4, 24.5],
    ]
)

xlabel = "Months"
ylabel = "Years"
zlabel = "Average Temperature (°C)"
title = "Average Monthly Temperatures (2000-2005)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig = plt.figure(
    figsize=(10, 6)
)  # Adjusting figure size to match original image's dimensions
ax = fig.add_subplot(111, projection="3d")

# Plot a 3D surface
surf = ax.plot_surface(months, years, temperatures, cmap="coolwarm", edgecolor="black", alpha=0.8)

# Labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title, y=1.05)
ax.set_box_aspect(aspect=[2, 1, 1])

# ===================
# Part 4: Saving Output
# ===================
# Saving the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_28.pdf", bbox_inches="tight")
