
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the synthetic meteorological data
latitude = np.linspace(-90, 90, 200)
longitude = np.linspace(-180, 180, 200)
latitude, longitude = np.meshgrid(latitude, longitude)

temperature = 20 + 10 * np.sin(np.deg2rad(latitude)) * np.cos(np.deg2rad(longitude))
humidity = 50 + 20 * np.sin(np.deg2rad(latitude)) * np.sin(np.deg2rad(longitude))
wind_speed = 10 + 5 * np.abs(np.sin(np.deg2rad(latitude)) * np.cos(np.deg2rad(longitude)))
pressure = 1013 + 10 * np.cos(np.deg2rad(latitude))

titles = ["Temperature Distribution", "Humidity Distribution", "Wind Speed Distribution", "Pressure Distribution"]
xlabels = ["Longitude", "Longitude", "Longitude", "Longitude"]
ylabels = ["Latitude", "Latitude", "Latitude", "Latitude"]
zlabels = ["Temperature (°C)", "Humidity (%)", "Wind Speed (m/s)", "Pressure (hPa)"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(15, 10))

# Plot the first subplot - Temperature Distribution
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
surf1 = ax1.plot_surface(longitude, latitude, temperature, cmap="hot")
ax1.set_title(titles[0], fontsize=14, y=-0.1)
ax1.set_xlabel(xlabels[0], fontsize=12)
ax1.set_ylabel(ylabels[0], fontsize=12)
ax1.set_zlabel(zlabels[0], fontsize=12)

# Plot the second subplot - Humidity Distribution
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(longitude, latitude, humidity, cmap="Blues")
ax2.set_title(titles[1], fontsize=14, y=-0.1)
ax2.set_xlabel(xlabels[1], fontsize=12)
ax2.set_ylabel(ylabels[1], fontsize=12)
ax2.set_zlabel(zlabels[1], fontsize=12)

# Plot the third subplot - Wind Speed Distribution
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(longitude, latitude, wind_speed, cmap="Greens")
ax3.set_title(titles[2], fontsize=14, y=-0.1)
ax3.set_xlabel(xlabels[2], fontsize=12)
ax3.set_ylabel(ylabels[2], fontsize=12)
ax3.set_zlabel(zlabels[2], fontsize=12)

# Plot the fourth subplot - Pressure Distribution
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(longitude, latitude, pressure, cmap="Greys")
ax4.set_title(titles[3], fontsize=14, y=-0.1)
ax4.set_xlabel(xlabels[3], fontsize=12)
ax4.set_ylabel(ylabels[3], fontsize=12)
ax4.set_zlabel(zlabels[3], fontsize=12)

# Adjust layout and spacing
plt.tight_layout()

# Show the plot
plt.savefig("3d_32.pdf", bbox_inches="tight")
