
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(0)
temperature = np.random.uniform(15, 35, 17)  # Simulated temperature data in Celsius
humidity = np.random.uniform(30, 80, 17)     # Simulated humidity data in percentage
co2_levels = np.random.uniform(300, 500, 17) # Simulated CO2 levels in ppm (parts per million)
label = "Environmental Measurements"

# Label texts for the chart
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
zlabel = "CO2 Levels (ppm)"
title = "3D Scatter Plot of Environmental Data"
legendlabel = "Measurements"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(7, 7), subplot_kw={"projection": "3d"})

# Axis limits
ax.set_xlim3d([15, 35])
ax.set_ylim3d([30, 80])
ax.set_zlim3d([300, 500])
ax.view_init(elev=15.0, azim=120)
ax.dist = 10

# 3D scatter plot
ax.scatter3D(temperature, humidity, co2_levels, color="forestgreen", label=label, marker="o", s=70)

# Connecting data points (example for trends)
ax.plot(temperature, humidity, co2_levels, ls="--", color="darkgreen", lw=1)

# Adding labels
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=14)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_33.pdf", bbox_inches="tight")
