
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm

# ===================
# Part 2: Data Preparation
# ===================
# Generate new data representing a sports field with terrain elevation
import numpy as np

np.random.seed(0)
X = np.arange(-50, 50, 1)
Y = np.arange(-50, 50, 1)
X, Y = np.meshgrid(X, Y)

# Elevation data with sinusoidal patterns to mimic terrain
Z = np.sin(X * 0.1) * np.cos(Y * 0.1)

# Axes Limits and Labels
xlabel_value = "Length (meters)"
ylabel_value = "Width (meters)"
title_value = "Sports Field Elevation Map"
zlim_values = [-1.5, 1.5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})
cmap_custom = cm.get_cmap("terrain")

# Plot the surface
surf = ax.plot_surface(X, Y, Z, cmap=cmap_custom, linewidth=1, edgecolor='k', antialiased=True)

# Customize the z axis
ax.set_zlim(zlim_values)
ax.zaxis.set_major_formatter("{x:.02f}")

# Labeling axes and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel("Elevation (meters)")
ax.set_title(title_value)

# Add a color bar which maps values to colors
fig.colorbar(surf, shrink=0.5, aspect=10)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_36.pdf", bbox_inches="tight")
