
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib import cm


# ===================
# Part 2: Data Preparation
# ===================
# Data for terrain-like surface.
import numpy as np
np.random.seed(0)
X = np.arange(-5, 5, 0.1)
Y = np.arange(-5, 5, 0.1)
X, Y = np.meshgrid(X, Y)
Z = np.sin(np.sqrt(X**2 + Y**2)) * np.cos(X * Y / 5)

# Axes Limits and Labels
xlabel_value = "Longitude"
ylabel_value = "Latitude"
title_value = "Simulated Terrain Elevation"
supertitle_value = "Geographical Elevations over Terrain"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8), subplot_kw={"projection": "3d"})

# Color and style adjustments
zlim_values = [-1.5, 1.5]
colormap = cm.terrain

# Plot the surface.
surf = ax.plot_surface(X, Y, Z, cmap=colormap, edgecolor='none')

# Customize the z axis.
ax.set_zlim(zlim_values)

# A StrMethodFormatter is used automatically
ax.zaxis.set_major_formatter("{x:.02f}")
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_zlabel('Elevation (m)')

# Add a color bar which maps values to colors.
fig.colorbar(surf, shrink=0.5, aspect=10)

# Add title and supertitle
plt.suptitle(supertitle_value, fontsize=16)
plt.title(title_value, fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_38.pdf", bbox_inches="tight")
