
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation 
# ===================
import numpy as np

np.random.seed(1)
# Data: Age, Income, Debt
undergraduate = np.array(
    [
        [22, 25, 24, 23, 26, 28, 24, 29, 27, 30],
        [35000, 40000, 37000, 39000, 42000, 45000, 41000, 47000, 44000, 46000],
        [-5000, -6000, -4500, -5500, -6500, -7000, -6000, -7500, -6700, -7200],
    ]
)
graduate = np.array(
    [
        [28, 30, 29, 32, 34, 36, 31, 35, 37, 33],
        [55000, 58000, 56000, 60000, 62000, 65000, 59000, 63000, 64000, 61000],
        [-10000, -11000, -9000, -12000, -13000, -14000, -11000, -12500, -13500, -12000],
    ]
)
postgraduate = np.array(
    [
        [35, 38, 40, 42, 43, 45, 41, 44, 46, 47],
        [75000, 80000, 78000, 85000, 88000, 90000, 82000, 86000, 89000, 92000],
        [-20000, -22000, -21000, -23000, -24000, -25000, -22000, -23500, -24500, -26000],
    ]
)
xlabel = "Age"
ylabel = "Annual Income (USD)"
zlabel = "Debt (USD)"
title = "Societal Trends: Age vs. Income vs. Debt"
legend_labels = ["Undergraduate", "Graduate", "Postgraduate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection='3d')

# Scatter plots with optimized elements
ax.scatter(undergraduate[0], undergraduate[1], undergraduate[2], marker="o", color="teal", s=50, label=legend_labels[0])
ax.scatter(graduate[0], graduate[1], graduate[2], marker="^", color="magenta", s=50, label=legend_labels[1])
ax.scatter(postgraduate[0], postgraduate[1], postgraduate[2], marker="s", color="olive", s=50, label=legend_labels[2])

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Adjust ticks
ax.set_xticks([20, 25, 30, 35, 40, 45, 50])
ax.set_yticks([30000, 40000, 50000, 60000, 70000, 80000, 90000])
ax.set_zticks([-30000, -25000, -20000, -15000, -10000, -5000, 0])

# Aspect ratio
ax.set_box_aspect([2, 1, 1])  # For a better visualization

# Adding Legend
ax.legend(loc='upper left')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_42.pdf", bbox_inches="tight")
