
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
device_a = np.array(
    [
        np.random.randint(50, 100, 10),  # Performance
        np.random.randint(30, 80, 10),   # Energy Consumption
        np.random.randint(200, 400, 10), # Cost
    ]
)
device_b = np.array(
    [
        np.random.randint(60, 110, 10),  # Performance
        np.random.randint(20, 70, 10),   # Energy Consumption
        np.random.randint(150, 350, 10), # Cost
    ]
)
device_c = np.array(
    [
        np.random.randint(70, 120, 10),  # Performance
        np.random.randint(25, 75, 10),   # Energy Consumption
        np.random.randint(100, 300, 10), # Cost
    ]
)
xlabel = "Performance"
ylabel = "Energy Consumption"
zlabel = "Cost"
title = "Technology Device Metrics"
legend_labels = ["Device A", "Device B", "Device C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.scatter(device_a[0], device_a[1], device_a[2], marker="o", color="steelblue", depthshade=False, label=legend_labels[0])
ax.scatter(device_b[0], device_b[1], device_b[2], marker="^", color="forestgreen", depthshade=False, label=legend_labels[1])
ax.scatter(device_c[0], device_c[1], device_c[2], marker="s", color="darkorange", depthshade=False, label=legend_labels[2])

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

ax.set_xticks(np.arange(50, 130, 10))
ax.set_yticks(np.arange(20, 90, 10))
ax.set_zticks(np.arange(100, 450, 50))

ax.legend()

# Adjust the aspect ratio and appearance
ax.set_box_aspect([1.5, 1, 1])  # aspect ratio is 1:1:1.5
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("3d_43.pdf", bbox_inches="tight")
