
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)
source1 = np.array([[0, 1, 2, 3, 4], [2, 4, 6, 8, 10], [7, 8, 9, 9.5, 10]])
source2 = np.array([[0, 1, 2, 3, 4], [1, 3, 5, 7, 9], [6, 7, 7.5, 8, 8.5]])
source3 = np.array([[0, 1, 2, 3, 4], [0.5, 2.5, 4.5, 6.5, 8.5], [5, 6, 6.5, 7, 7.5]])

xlabel = "Time (weeks)"
ylabel = "Number of Reviews"
zlabel = "Rating (out of 10)"
chart_title = "Movie Ratings Over Time"
legend_labels = ["Review Source 1", "Review Source 2", "Review Source 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

ax.plot(source1[0], source1[1], source1[2], color="purple", linestyle='--', marker='o', label=legend_labels[0])
ax.plot(source2[0], source2[1], source2[2], color="green", linestyle='-.', marker='s', label=legend_labels[1])
ax.plot(source3[0], source3[1], source3[2], color="teal", linestyle=':', marker='^', label=legend_labels[2])

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(chart_title)
ax.legend()

ax.set_xticks(np.arange(0, 5, 1))
ax.set_yticks(np.arange(0, 11, 2))
ax.set_zticks(np.arange(5, 11, 0.5))

ax.grid(True)
ax.set_box_aspect(aspect=[2, 2, 2])

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_45.pdf", bbox_inches="tight")
