
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
country1 = np.array([[1, 2, 3, 4, 5], [2, 3, 4, 5, 6], [3, 4, 5, 6, 7]])
country2 = np.array([[1, 2, 3, 4, 5], [1, 2, 3, 4, 5], [2, 3, 4, 5, 6]])
country3 = np.array([[1, 2, 3, 4, 5], [3, 4, 5, 6, 7], [1, 2, 3, 4, 5]])
xlabel = "Years"
ylabel = "GDP Growth Rate (%)"
zlabel = "Economic Indicator Z"
title = "GDP Growth Rates Over Time for Three Countries"
legendlabels = ["Country A", "Country B", "Country C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Use different style and colors for lines.
ax.plot(country1[0], country1[1], country1[2], color="teal", linestyle="-", marker='o', linewidth=2, label=legendlabels[0])
ax.plot(country2[0], country2[1], country2[2], color="goldenrod", linestyle="--", marker='s', linewidth=2, label=legendlabels[1])
ax.plot(country3[0], country3[1], country3[2], color="coral", linestyle=":", marker='^', linewidth=2, label=legendlabels[2])

ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15, pad=20)

ax.set_xticks([1, 2, 3, 4, 5])
ax.set_yticks([1, 2, 3, 4, 5, 6, 7])
ax.set_zticks([1, 2, 3, 4, 5, 6, 7])

ax.legend(loc='upper left')

# Set the aspect and zoom level
ax.set_box_aspect(aspect=None, zoom=0.9)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_46.pdf", bbox_inches="tight")

