
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
sculpture_type_A = np.array([[5.0, 15.0], [5.0, 25.0], [15.0, 5.0]])
sculpture_type_B = np.array([[10.0, 20.0], [30.0, 60.0], [5.0, 10.0]])
sculpture_type_C = np.array([[15.0, 25.0], [45.0, 85.0], [10.0, 20.0]])
xlabel = "Width (cm)"
ylabel = "Height (cm)"
zlabel = "Depth (cm)"
title = "3D Visualization of Sculpture Dimensions"
legend_labels = ["Type A", "Type B", "Type C"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Plotting the data with enhanced styles
ax.plot(sculpture_type_A[0], sculpture_type_A[1], sculpture_type_A[2], color="#5b5fc7", linestyle='--', linewidth=2, marker='o', markersize=6, label=legend_labels[0])
ax.plot(sculpture_type_B[0], sculpture_type_B[1], sculpture_type_B[2], color="#76c043", linestyle='-.', linewidth=2, marker='s', markersize=6, label=legend_labels[1])
ax.plot(sculpture_type_C[0], sculpture_type_C[1], sculpture_type_C[2], color="#c49820", linestyle=':', linewidth=2, marker='^', markersize=6, label=legend_labels[2])

# Setting axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15, pad=20)

# Customizing ticks
ax.set_xticks([5, 10, 15, 20, 25])
ax.set_yticks([5, 25, 45, 65, 85])
ax.set_zticks([5, 10, 15, 20])

# Adding legend
ax.legend(loc='upper left', fontsize=10)

# Improving the aspect ratio
ax.set_box_aspect([1.5, 1.5, 1.5])  # [x, y, z]

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_47.pdf", bbox_inches="tight")
