
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Labels and Titles
xlabel = 'Time'
ylabel = 'Frequency'
zlabel = 'Signal Strength'
title = '3D Signal Strength Over Time'
legendlabel = 'Signal Surface'

# Generate new data suitable for the technology domain
np.random.seed(42)
t = np.linspace(0, 4 * np.pi, 100)
f = np.linspace(0, 2 * np.pi, 100)
t, f = np.meshgrid(t, f)
z = np.sin(t) * np.cos(f)

# Ensuring the data is reshaped correctly for the 3D plot
x, y = np.meshgrid(t[0], f[:, 0])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Plot the surface with a new color scheme
surf = ax.plot_surface(x, y, z, cmap='viridis', edgecolor='none')

# Adding color bar for reference
fig.colorbar(surf, shrink=0.5, aspect=5, label=zlabel)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Set chart title
ax.set_title(title)

# Setting ticks for better readability
ax.set_xticks(np.linspace(t.min(), t.max(), 5))
ax.set_yticks(np.linspace(f.min(), f.max(), 5))
ax.set_zticks(np.linspace(z.min(), z.max(), 5))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_52.pdf", bbox_inches="tight")
