
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generating a new dataset
np.random.seed(0)
x = np.linspace(0, 10, 9)  # Time
y = np.linspace(0, 10, 9)  # Experience
z = np.sin(x) * np.cos(y) * 10  # Wisdom
z_fit = np.poly1d(np.polyfit(x, z, 2))(x)  # Fitting a quadratic trend

# Setting labels and legends
xlabel = "Time (Years)"
ylabel = "Experience (Levels)"
zlabel = "Wisdom (Units)"
title = "Growth of Wisdom Over Time and Experience"
labels = ["Observed Wisdom", "Wisdom Trend Line"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection="3d")

# Setting colors and styles
scatter_color = "#a1dab4"  # Light green
line_color = "#2c7fb8"  # Medium blue

ax.scatter(x, y, z, color=scatter_color, label=labels[0], marker="^")
ax.plot(x, y, z_fit, color=line_color, linestyle='--', linewidth=2, label=labels[1])

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Adding legends
ax.legend()

# Set aspect ratio and zoom
ax.set_box_aspect(aspect=[1.2,1.2,1.2], zoom=0.9)

# Adding gridlines
ax.grid(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_54.pdf", bbox_inches="tight")
