
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Independent variables
hours_sleep = np.array([4, 5, 6, 7, 8, 9, 10])
stress_level = np.array([80, 70, 60, 50, 40, 30, 20])
# Dependent variable (mood score)
mood_score = np.array([30, 40, 50, 60, 70, 80, 90])
mood_score_fit = np.polyval(np.polyfit(hours_sleep, mood_score, 1), hours_sleep)

# Labels
xlabel = "Hours of Sleep"
ylabel = "Stress Level"
zlabel = "Mood Score"
labels = ["Observed Mood Scores", "Fitted Mood Trend"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection="3d")

# Scatter plot
ax.scatter(hours_sleep, stress_level, mood_score, color="#FF6347", label=labels[0], marker="^")

# Fit line
ax.plot(hours_sleep, stress_level, mood_score_fit, color="#4682B4", label=labels[1], linestyle='--', linewidth=2)

# Setting axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Customizing legend
ax.legend()

# Box aspect and zoom adjustments
ax.set_box_aspect(aspect=[2, 1, 1])

# Title and additional style enhancements
ax.set_title("Relationship Between Sleep, Stress, and Mood", fontsize=14, fontweight='bold')
fig.suptitle("Psychological Data Visualization", fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_56.pdf", bbox_inches="tight")
