
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Set seed for reproducibility
yticklabels = ["Print Media", "Online Media"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
online_media = np.array([0.35, 0.40, 0.45, 0.50, 0.55, 0.60, 0.68, 0.75, 0.80, 0.85])
print_media = np.array([0.70, 0.68, 0.65, 0.60, 0.55, 0.50, 0.45, 0.40, 0.35, 0.30])
xlabel = "Year"
ylabel = "Media Type"
zlabel = "Adoption Rate"
title = "Adoption Rate of Media Types Over Years"
legend_labels = ["Print Media", "Online Media"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Customize bar colors
online_color = "coral"
print_color = "darkturquoise"

# Plot bars
ax.bar(years, print_media, zs=0, zdir="y", color=print_color, alpha=0.8)
ax.bar(years, online_media, zs=1, zdir="y", color=online_color, alpha=0.8)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Set y-ticks and labels
ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend(legend_labels, loc='upper left', bbox_to_anchor=(0.05, 0.95))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_58.pdf", bbox_inches="tight")
