
# ===================
# Part 1: Importing Libraries
# ===================
import math
import matplotlib.pyplot as plt
from matplotlib.collections import PolyCollection

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

def polygon_under_graph(x, y):
    """
    Construct the vertex list which defines the polygon filling the space under
    the (x, y) line graph. This assumes x is in ascending order.
    """
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

x = np.linspace(0.0, 10.0, 31)
policy_scenarios = range(1, 4)

# Example of population growth rates under different policy scenarios
verts = [
    polygon_under_graph(x, np.log(1 + v*x)) 
    for v in policy_scenarios
]

xlabel = "Years"
ylabel = "Policy Scenario"
zlabel = "Population Growth Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(7, 8))
ax = fig.add_subplot(projection="3d")

# Custom color palette
facecolors = ['#1f77b4', '#ff7f0e', '#2ca02c']

poly = PolyCollection(verts, facecolors=facecolors, alpha=0.7)
ax.add_collection3d(poly, zs=policy_scenarios, zdir='y')

ax.set_xlim(0, 10)
ax.set_ylim(1, 4)
ax.set_zlim(0, 4)
ax.set_xlabel(xlabel, fontsize=12, labelpad=10)
ax.set_ylabel(ylabel, fontsize=12, labelpad=10)
ax.set_zlabel(zlabel, fontsize=12, labelpad=10)

ax.set_yticks(policy_scenarios)
ax.set_box_aspect(aspect=None, zoom=0.9)

plt.title('Population Growth Trends Under Different Policies', fontsize=14, pad=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_61.pdf", bbox_inches="tight")
