
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.collections import PolyCollection

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Function to create polygon under graph
def polygon_under_graph(x, y):
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

# Data for bar chart
years = [2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019]
Team_A = [55, 60, 62, 65, 70, 75, 80, 85, 88, 90]  # Win percentages for Team A
Team_B = [50, 55, 58, 60, 65, 68, 70, 75, 78, 80]  # Win percentages for Team B

# Data for distribution graph
x = np.linspace(0.0, 10.0, 31)
viewer_levels = range(1, 4)
exp = np.exp
verts = [polygon_under_graph(x, exp(-0.5 * (x - v) ** 2)) for v in viewer_levels]

xlabels = ["Year", "Time Since Start (Years)"]
ylabels = ["Team", "Viewer Level"]
zlabels = ["Win Percentage (%)", "Growth Rate"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
facecolors = plt.colormaps["viridis"](np.linspace(0, 1, len(verts)))

# Initialize figure and axes
fig = plt.figure(figsize=(12, 8))
ax1 = fig.add_subplot(121, projection="3d")  # 3D bar chart
ax2 = fig.add_subplot(122, projection="3d")  # 3D distribution graph

# Bar chart for teams
ax1.bar(years, Team_A, zs=0, zdir="y", color="#FF5733", alpha=0.8, edgecolor='k')
ax1.bar(years, Team_B, zs=1, zdir="y", color="#337DFF", alpha=0.8, edgecolor='k')

# Set labels and ticks for bar chart
ax1.set_xlabel(xlabels[0])
ax1.set_ylabel(ylabels[0])
ax1.set_zlabel(zlabels[0])
ax1.set_yticks([0, 1])
ax1.set_yticklabels(["Team A", "Team B"])
ax1.set_title("Teams' Win Percentages Over the Years")

# Add polygons to the plot
poly = PolyCollection(verts, facecolors=facecolors, alpha=0.7)
ax2.add_collection3d(poly, zs=viewer_levels, zdir="y")

# Set labels and limits for distribution graph
ax2.set_xlim(0, 10)
ax2.set_ylim(1, 4)
ax2.set_zlim(0, 1)
ax2.set_xlabel(xlabels[1])
ax2.set_ylabel(ylabels[1])
ax2.set_zlabel(zlabels[1])
ax2.set_yticks([1, 2, 3])
ax2.set_title("Viewership Growth Over Time")

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
ax1.set_box_aspect(aspect=None, zoom=0.9)
ax2.set_box_aspect(aspect=None, zoom=0.8)
plt.savefig("3d_65.pdf", bbox_inches="tight")
