
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for atmospheric conditions (temperature, humidity, wind speed)
np.random.seed(42)

# Temperature data (Celsius)
temperature_set1 = np.random.normal(loc=22, scale=5, size=50)  # mean temperature around 22°C
temperature_set2 = np.random.normal(loc=25, scale=4, size=50)  # mean temperature around 25°C

# Humidity data (%RH)
humidity_set1 = np.random.uniform(low=40, high=80, size=50)  # between 40% and 80%
humidity_set2 = np.random.uniform(low=45, high=85, size=50)  # between 45% and 85%

# Wind Speed data (km/h)
windspeed_set1 = np.random.normal(loc=15, scale=3, size=50)  # mean wind speed around 15 km/h
windspeed_set2 = np.random.normal(loc=18, scale=2.5, size=50)  # mean wind speed around 18 km/h

labels = ["Condition Set 1", "Condition Set 2"]
xlabel = "Temperature (°C)"
ylabel = "Humidity (%RH)"
zlabel = "Wind Speed (km/h)"
title = "Atmospheric Condition Patterns"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([10, 35])
ax.set_ylim3d([30, 90])
ax.set_zlim3d([5, 25])

# Set the viewing angle
ax.view_init(elev=30, azim=45)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(temperature_set1, humidity_set1, windspeed_set1, color="#1f77b4", marker="o", label=labels[0], edgecolor='k')

# Scatter plot for the second set of data
ax.scatter3D(temperature_set2, humidity_set2, windspeed_set2, color="#ff7f0e", marker="^", label=labels[1], edgecolor='k')

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12, labelpad=10)
ax.set_ylabel(ylabel, fontsize=12, labelpad=10)
ax.set_zlabel(zlabel, fontsize=12, labelpad=10)
ax.set_title(title, fontsize=15, pad=20)

# Legend for the plot
plt.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_66.pdf", bbox_inches="tight")
