
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for weather (temperature, humidity, and wind speed)
np.random.seed(42)

# Temperature data (in Celsius)
temperature = np.random.normal(
    loc=20, scale=5, size=50
)  # mean temperature around 20°C

# Humidity data (in percentage)
humidity = np.random.uniform(
    low=30, high=90, size=50
)  # randomly between 30% and 90%

# Wind speed data (in km/h)
wind_speed = np.random.normal(
    loc=15, scale=5, size=50
)  # mean wind speed around 15 km/h

# Second set of data for variations in different conditions
temperature2 = np.random.normal(loc=25, scale=3, size=50)
humidity2 = np.random.uniform(low=40, high=85, size=50)
wind_speed2 = np.random.normal(loc=10, scale=4, size=50)

labels = ["Weather Set 1", "Weather Set 2"]
xlabel = "Temperature (°C)"
ylabel = "Humidity (%)"
zlabel = "Wind Speed (km/h)"
title = "3D Weather Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([10, 35])
ax.set_ylim3d([20, 100])
ax.set_zlim3d([0, 30])

# Set the viewing angle
ax.view_init(elev=30, azim=70)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(temperature, humidity, wind_speed, color="#1f77b4", marker="o", label=labels[0])

# Scatter plot for the second set of data
ax.scatter3D(temperature2, humidity2, wind_speed2, color="#ff7f0e", marker="^", label=labels[1])

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15)

# Legend for the plot
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_68.pdf", bbox_inches="tight")
