
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Set a random seed for reproducibility
import numpy as np
np.random.seed(0)

# Define the data for the political metrics surface plots
x = np.linspace(-50, 50, 200)
y = np.linspace(-50, 50, 200)
x, y = np.meshgrid(x, y)
z1 = 0.005 * np.sqrt(x**2 + y**2)  # Political Stability Index: steady increase
z2 = np.cos(0.1 * np.sqrt(x**2 + y**2)) * 5  # Corruption Index: periodic fluctuations
z3 = 100 - np.sqrt(x**2 + y**2)  # Public Trust Index: decreasing trend
z4 = np.log(x**2 + y**2 + 1)  # General Governance Index: logarithmic growth

# Extracted text variables
title_stability_index = "Political Stability Index"
title_corruption_index = "Corruption Index"
title_trust_index = "Public Trust Index"
title_governance_index = "General Governance Index"
x_label = "X Axis"
y_label = "Y Axis"
z_label_stability = "Stability Value"
z_label_corruption = "Corruption Value"
z_label_trust = "Trust Value"
z_label_governance = "Governance Value"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
font_size = 12
title_pad = 10

# Create a figure with specified size
fig = plt.figure(figsize=(14, 10))

# Plot the first subplot
ax1 = fig.add_subplot(141, projection="3d", facecolor="white")
surf1 = ax1.plot_surface(x, y, z1, cmap="Blues", edgecolor='none')
ax1.set_title(title_stability_index, fontsize=font_size, pad=title_pad)
ax1.set_xlabel(x_label, fontsize=font_size)
ax1.set_ylabel(y_label, fontsize=font_size)
ax1.set_zlabel(z_label_stability, fontsize=font_size)

# Plot the second subplot
ax2 = fig.add_subplot(142, projection="3d", facecolor="white")
surf2 = ax2.plot_surface(x, y, z2, cmap="Greens", edgecolor='none')
ax2.set_title(title_corruption_index, fontsize=font_size, pad=title_pad)
ax2.set_xlabel(x_label, fontsize=font_size)
ax2.set_ylabel(y_label, fontsize=font_size)
ax2.set_zlabel(z_label_corruption, fontsize=font_size)

# Plot the third subplot
ax3 = fig.add_subplot(143, projection="3d", facecolor="white")
surf3 = ax3.plot_surface(x, y, z3, cmap="Greys", edgecolor='none')
ax3.set_title(title_trust_index, fontsize=font_size, pad=title_pad)
ax3.set_xlabel(x_label, fontsize=font_size)
ax3.set_ylabel(y_label, fontsize=font_size)
ax3.set_zlabel(z_label_trust, fontsize=font_size)

# Plot the fourth subplot
ax4 = fig.add_subplot(144, projection="3d", facecolor="white")
surf4 = ax4.plot_surface(x, y, z4, cmap="Oranges", edgecolor='none')
ax4.set_title(title_governance_index, fontsize=font_size, pad=title_pad)
ax4.set_xlabel(x_label, fontsize=font_size)
ax4.set_ylabel(y_label, fontsize=font_size)
ax4.set_zlabel(z_label_governance, fontsize=font_size)

# Make sure all subplots have a consistent view initialization
for ax in [ax1, ax2, ax3, ax4]:
    ax.view_init(30, 45)
    ax.grid(True)  # Adding grid for readability

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and spacing
plt.tight_layout()

# Save the plot to a file
plt.savefig("3d_73.pdf", bbox_inches="tight")
