
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(0)

# Sample data for artistic brushstroke lengths
x1 = np.linspace(10, 50, 100)   # Short strokes
y1 = norm.pdf(x1, 30, 5)
x2 = np.linspace(50, 90, 100)   # Medium strokes
y2 = norm.pdf(x2, 70, 5)
x3 = np.linspace(90, 130, 100)  # Long strokes
y3 = norm.pdf(x3, 110, 5)
labels = ["Short Strokes", "Medium Strokes", "Long Strokes"]
xlabel = "Brushstroke Length (mm)"
ylabel = "Frequency"
annotation_texts = ["20 units", "40 units", "20 units"]
title = "Distribution of Brushstroke Lengths in Abstract Art"
legend_labels = ["Short Strokes", "Medium Strokes", "Long Strokes"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the distributions with customized styles
ax.plot(x1, y1, linestyle='--', linewidth=2, color='#FF6347', label=labels[0])
ax.plot(x2, y2, linestyle='-', linewidth=2, color='#4682B4', label=labels[1])
ax.plot(x3, y3, linestyle=':', linewidth=2, color='#32CD32', label=labels[2])

# Adding histograms with filled colors
ax.hist(np.random.normal(30, 5, 1000), bins=10, density=True, alpha=0.6, color='#FFA07A')
ax.hist(np.random.normal(70, 5, 1000), bins=10, density=True, alpha=0.6, color='#B0E0E6')
ax.hist(np.random.normal(110, 5, 1000), bins=10, density=True, alpha=0.6, color='#98FB98')

# Add annotations
ax.annotate("", xy=(30, 0.06), xytext=(70, 0.06), arrowprops=dict(facecolor="black", arrowstyle="<->"))
ax.annotate("", xy=(30, 0.08), xytext=(110, 0.08), arrowprops=dict(facecolor="black", arrowstyle="<->"))
ax.annotate("", xy=(70, 0.05), xytext=(110, 0.05), arrowprops=dict(facecolor="black", arrowstyle="<->"))

# Text annotations
ax.text(50, 0.061, annotation_texts[0], fontsize=12, ha="center")
ax.text(70, 0.081, annotation_texts[1], fontsize=12, ha="center")
ax.text(90, 0.051, annotation_texts[2], fontsize=12, ha="center")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis and y-ticks
ax.set_ylim(0.00, 0.10)
ax.set_yticks([0.00, 0.03, 0.06, 0.09])
# Adding grid lines
ax.grid(True, linestyle='--', alpha=0.7)

# Add legend
ax.legend(legend_labels, ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_100.pdf", bbox_inches="tight")
