
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(42)

# New Sample data: CPU usage distributions during different workloads
x1 = np.linspace(0, 100, 100)
y1 = norm.pdf(x1, 30, 10)  # Light workload
x2 = np.linspace(0, 100, 100)
y2 = norm.pdf(x2, 50, 10)  # Moderate workload
x3 = np.linspace(0, 100, 100)
y3 = norm.pdf(x3, 70, 10)  # Heavy workload

# Text Labels
labels = ["Light Workload", "Moderate Workload", "Heavy Workload"]
xlabel = "CPU Usage (%)"
ylabel = "Density"
annotation_texts = ["20%", "40%", "20%"]
title = "CPU Usage Distributions during Different Workloads"
legend_labels = [labels[0], labels[1], labels[2]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the distributions with new styles
ax.plot(x1, y1, color="skyblue", linestyle='-', linewidth=2, label=labels[0])
ax.plot(x2, y2, color="lightgreen", linestyle='--', linewidth=2, label=labels[1])
ax.plot(x3, y3, color="slategrey", linestyle=':', linewidth=2, label=labels[2])

# Draw histograms
ax.hist(np.random.normal(30, 10, 1000), bins=5, density=True, alpha=0.5, color="lightblue")
ax.hist(np.random.normal(50, 10, 1000), bins=5, density=True, alpha=0.5, color="lightgreen")
ax.hist(np.random.normal(70, 10, 1000), bins=5, density=True, alpha=0.5, color="lightgrey")

# Add annotations
ax.annotate(
    annotation_texts[0],
    xy=(30, 0.035),
    xytext=(50, 0.035),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    annotation_texts[1],
    xy=(30, 0.05),
    xytext=(70, 0.05),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    annotation_texts[2],
    xy=(50, 0.02),
    xytext=(70, 0.02),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)

# Add text on corresponding positions
ax.text(40, 0.036, "20%", fontsize=12, ha="center")
ax.text(50, 0.051, "40%", fontsize=12, ha="center")
ax.text(60, 0.021, "20%", fontsize=12, ha="center")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Set y-axis limits and ticks
ax.set_ylim(0.00, 0.06)
ax.set_yticks([0.00, 0.02, 0.04, 0.06])

# Add legend
ax.legend(ncol=1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_101.pdf", bbox_inches="tight")

