
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data
years = ["2000", "2005", "2010", "2015", "2020", "2025", "2030", "2035"]
Model_A = [1500, 1600, 1700, 1800, 1900, 2000, 2100, 2200]
Model_B = [1400, 1550, 1650, 1750, 1850, 1950, 2050, 2150]
Model_C = [1300, 1450, 1550, 1650, 1750, 1850, 1950, 2050]
Model_D = [1350, 1500, 1600, 1700, 1800, 1900, 2000, 2100]
growth_rate = [0.05, 0.04, 0.03, 0.025, 0.02, 0.015, 0.01, 0.005]
labels = ["Model_A", "Model_B", "Model_C", "Model_D"]
xlabel = "Year"
ylabel1 = "Population (in millions)"
ylabel2 = "Growth Rate (%)"
legend_title = "Population Models"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(years))
ax1.bar(index, Model_A, bar_width, label=labels[0], color="#FF9999")  # Light Red
ax1.bar(index + bar_width, Model_B, bar_width, label=labels[1], color="#66B3FF")  # Light Blue
ax1.bar(index + 2 * bar_width, Model_C, bar_width, label=labels[2], color="#99FF99")  # Light Green
ax1.bar(index + 3 * bar_width, Model_D, bar_width, label=labels[3], color="#FFCC99")  # Light Orange

# Line plot
ax2 = ax1.twinx()
ax2.plot(
    years,
    growth_rate,
    color="purple",
    marker="D",
    linestyle="--",
    linewidth=2,
    markersize=7,
)

# Annotate growth rate percentages
for i, rate in enumerate(growth_rate):
    ax2.annotate(
        f"{rate*100:.1f}%",
        (index[i] + bar_width * 1.5, rate),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        color="purple",
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(years)

# Add legend
ax1.legend(loc="upper left", ncol=1, bbox_to_anchor=(1, 1), title=legend_title)
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# Set ax2.yticklabels to be percentages
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the plot as a PDF file
plt.savefig("CB_105.pdf", bbox_inches="tight")
