
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
platforms = [
    "Netflix",
    "YouTube",
    "Spotify",
    "Amazon Prime",
    "Hulu",
    "Disney+",
]
engagement_time = [2.5, 3.0, 1.5, 2.0, 1.8, 2.2]  # hours per day
data_usage = [1.5, 1.8, 1.2, 1.4, 1.3, 1.6]  # GB/day
revenue = [8.0, 12.0, 3.5, 9.0, 4.5, 7.0]  # Billion USD
user_growth = [5, 7, 4, 6, 5, 6]  # %

labels = ["Engagement Time (hrs/day)", "Data Usage (GB/day)", "Revenue (Billion USD)", "User Growth (%)"]
x_name = "Media Platforms"
bar_name = "KPI Values"
line_name = "User Growth (%)"
line_label = "User Growth"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the new domain's requirements
fig, ax1 = plt.subplots(figsize=(12, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(platforms))
bar1 = ax1.bar(index, engagement_time, bar_width, label=labels[0], color="#3498db")
bar2 = ax1.bar(index + bar_width, data_usage, bar_width, label=labels[1], color="#e74c3c")
bar3 = ax1.bar(index + 2 * bar_width, revenue, bar_width, label=labels[2], color="#2ecc71")

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(
    index + bar_width + bar_width / 2,
    user_growth,
    label=line_label,
    color="#8e44ad",
    marker="s",
    markersize=10,
    linewidth=2,
    linestyle="--",
    markeredgewidth=2,
    markeredgecolor="white",
)

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=14, fontweight='bold')
ax1.set_ylabel(bar_name, fontsize=14, fontweight='bold')
ax1.set_xticks(index + bar_width + bar_width / 2)
ax1.set_xticklabels(platforms, fontsize=12, rotation=45, ha='right')
ax1.legend(loc="upper left", fontsize=12)
ax2.legend(loc="upper right", fontsize=12)
ax2.set_ylabel(line_name, fontsize=14, fontweight='bold')

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

plt.title("Media Platform Performance Metrics", fontsize=16, fontweight='bold')
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save plot
plt.savefig("CB_40.pdf", bbox_inches="tight")

# Show plot
