
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for plotting
methods = [
    "Solar Panels",
    "Wind Turbines",
    "Hydro Power",
    "Geothermal",
    "Biomass",
    "Nuclear",
]
energy_usage = [0.15, 0.3, 0.25, 0.4, 0.35, 0.2]
carbon_footprint = [0.05, 0.1, 0.2, 0.15, 0.3, 0.25]
cost_per_unit = [0.4, 0.35, 0.3, 0.5, 0.45, 0.4]
maintenance_cost = [0.1, 0.2, 0.25, 0.3, 0.3, 0.35]
effectiveness = [85, 75, 90, 80, 70, 95]
labels = ["Energy Usage", "Carbon Footprint", "Cost per Unit", "Maintenance Cost"]
x_name = "Energy Methods"
bar_name = "Normalized Factors (lower is better)"
line_name = "Effectiveness (%)"

line_label = "Effectiveness"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image's dimensions
fig, ax1 = plt.subplots(figsize=(10, 5))

# Bar plot
bar_width = 0.2
index = np.arange(len(methods))
bar1 = ax1.bar(index, energy_usage, bar_width, label=labels[0], color="#76c7c0")
bar2 = ax1.bar(
    index + bar_width,
    carbon_footprint,
    bar_width,
    label=labels[1],
    color="#ffcc5c",
)
bar3 = ax1.bar(
    index + 2 * bar_width, cost_per_unit, bar_width, label=labels[2], color="#6b5b95"
)
bar4 = ax1.bar(
    index + 3 * bar_width,
    maintenance_cost,
    bar_width,
    label=labels[3],
    color="#d64161",
)

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(
    index + bar_width + bar_width / 2,
    effectiveness,
    label=line_label,
    color="black",
    marker="D",
    markersize=10,
    linewidth=2,
    linestyle='--',
    markeredgecolor="white",
)

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=12)
ax1.set_ylabel(bar_name, fontsize=12)
ax1.set_xticks(index + bar_width + bar_width / 2)
ax1.set_xticklabels(methods, fontsize=12)
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")
ax2.set_ylabel(line_name, fontsize=12)

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_41.pdf", bbox_inches="tight")
