
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data for plotting
methods = ["Method A", "Method B", "Method C", "Method D", "Method E", "Method F"]
train_sec_img = [0.15, 0.35, 0.5, 0.85, 0.55, 0.3]
inference_GFLOPs = [0.9, 1.1, 0.95, 1.2, 1.0, 0.85]
param_log10 = [0.25, 0.6, 1.3, 1.0, 0.8, 0.7]
train_memory = [0.55, 0.45, 1.5, 0.95, 0.5, 0.4]
accuracy = [70, 74, 77, 81, 78, 79]
labels = ["Training Time (sec)", "Inference FLOPs (GFLOPs)", "Parameters (log10)", "Training Memory (GB)"]
x_name = "Media Processing Methods"
bar_name = "Normalized Resource Requirements (lower is better)"
line_name = "Processing Quality (%)"
line_label = "Quality"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image's dimensions
fig, ax1 = plt.subplots(figsize=(12, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(methods))
bar1 = ax1.bar(index, train_sec_img, bar_width, label=labels[0], color="#4b8bbe")
bar2 = ax1.bar(index + bar_width, inference_GFLOPs, bar_width, label=labels[1], color="#f4a582")
bar3 = ax1.bar(index + 2 * bar_width, param_log10, bar_width, label=labels[2], color="#92c5de")
bar4 = ax1.bar(index + 3 * bar_width, train_memory, bar_width, label=labels[3], color="#d6604d")

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(index + 1.5 * bar_width, accuracy, label=line_label, color="#2166ac", marker="X", markersize=14, linewidth=2, markeredgecolor="white")

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=12)
ax1.set_ylabel(bar_name, fontsize=12)
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(methods, fontsize=12)
ax1.legend(loc="upper left", fontsize=9)
ax2.legend(loc="upper right", fontsize=9)
ax2.set_ylabel(line_name, fontsize=12)

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_42.pdf", bbox_inches="tight")
