
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
x = [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]
y = [120, 115, 110, 108, 105, 102, 100, 98, 97, 95, 92]  # Blood pressure in mmHg
percentages = [
    "120 mmHg",
    "115 mmHg",
    "110 mmHg",
    "108 mmHg",
    "105 mmHg",
    "102 mmHg",
    "100 mmHg",
    "98 mmHg",
    "97 mmHg",
    "95 mmHg",
    "92 mmHg",
]

# Axes Limits and Labels
xlabel_value = "Daily Exercise (minutes)"
ylabel_value = "Blood Pressure (mmHg)"
xticklabels = [f"{num} min" for num in x]
yticklabels = [f"{num} mmHg" for num in y]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plot data with different marker style
ax.plot(x, y, color="#2ca02c", linestyle="--", linewidth=2)  # Green dashed line
ax.scatter(x, y, marker="D", color="#ff7f0e", s=100)  # Orange diamond marker

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=10,
        fontweight='bold'
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Set ticks
ax.set_xticks(x)
ax.set_yticks(y)

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=10)
ax.set_yticklabels(yticklabels, fontsize=10)

# Set grid with lighter lines
ax.grid(True, linestyle="-.", linewidth=0.7, color="gray")

# Set title
ax.set_title("Correlation Between Daily Exercise and Blood Pressure", fontsize=16, fontweight='bold')
fig.suptitle("Health Data Analysis", fontsize=18, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_50.pdf", bbox_inches="tight")
