
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
x = np.array([70, 75, 80, 85, 90, 95, 100, 105, 110, 115, 120])
y = np.array([68, 73, 77, 82, 87, 92, 97, 101, 106, 110, 115])
percentages = [
    "2.9%",
    "2.7%",
    "3.8%",
    "3.5%",
    "3.3%",
    "3.2%",
    "3.0%",
    "3.8%",
    "3.6%",
    "4.3%",
    "4.2%",
]

# Axes Limits and Labels
xlabel_value = "Resting Heart Rate Before Fitness Program (BPM)"
ylabel_value = "Resting Heart Rate After Fitness Program (BPM)"
xticklabels = [f"{num} BPM" for num in x]
yticklabels = [f"{num} BPM" for num in y]
title_value = "Comparison of Resting Heart Rates Before and After a Fitness Program"
supertitle_value = "Heart Rate Improvement Data"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot data with different marker style
ax.plot(x, y, color="teal", linestyle='--', linewidth=2)
ax.scatter(x, y, marker="^", color="orange", s=100)

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title_value, fontsize=14)
fig.suptitle(supertitle_value, fontsize=16, fontweight='bold')

# Set ticks
ax.set_xticks(x)
ax.set_yticks(y)

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=9)
ax.set_yticklabels(yticklabels, fontsize=9)

# Set grid with lighter lines
ax.grid(True, linestyle="--", linewidth=0.5, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_51.pdf", bbox_inches="tight")
