
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for demonstration purposes
tomatoes_yield = np.random.normal(loc=3, scale=0.5, size=1000)  # yield in kg/sq meter
corn_yield = np.random.normal(loc=6, scale=1, size=1000)  # yield in kg/sq meter

# Compute KDE for both datasets
kde_tomatoes = gaussian_kde(tomatoes_yield)
kde_corn = gaussian_kde(corn_yield)

# Create an array of values for plotting KDE
x_eval = np.linspace(
    min(np.concatenate([tomatoes_yield, corn_yield])),
    max(np.concatenate([tomatoes_yield, corn_yield])),
    1000,
)
labels = ["Tomatoes", "Corn", "Tomatoes KDE", "Corn KDE"]
p_text = "T-test p-value = 0.0000"
x_label = "Yield (kg/sq meter)"
y_label = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Plot histograms
plt.hist(
    corn_yield, density=True, bins=30, color="#ffeb3b", alpha=0.8, label=labels[0]
)
plt.hist(
    tomatoes_yield, density=True, bins=30, color="#4caf50", alpha=0.8, label=labels[1]
)

# Plot KDEs
plt.plot(
    x_eval,
    kde_corn(x_eval),
    linestyle="-",
    color="#f57f17",
    label=labels[2],
)
plt.plot(
    x_eval,
    kde_tomatoes(x_eval),
    linestyle="-",
    color="#1b5e20",
    label=labels[3],
)

# Add legend
plt.legend()

# Add T-test p-value text
plt.text(4, 0.6, p_text, fontsize=10)

# Set labels and title
plt.xlabel(x_label)
plt.ylabel(y_label)

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_64.pdf", bbox_inches="tight")

