
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
tasks = ["Blood Test", "MRI Scan", "CT Scan", "Ultrasound"]
scores_method1 = [0.52, 0.68, 0.73, 0.65]
scores_method1_APE = [0.55, 0.70, 0.76, 0.67]
scores_method2 = [0.60, 0.75, 0.80, 0.72]
scores_method2_APE = [0.62, 0.78, 0.82, 0.75]
scores_best = [0.64, 0.74, 0.78, 0.71]
scores_iterative_best = [0.66, 0.76, 0.79, 0.73]
scores_sum_best = [0.68, 0.77, 0.81, 0.74]
trend = [0.60, 0.72, 0.78, 0.69]
title = "Comparison of Medical Test Scores"
labels = [
    "Method1",
    "Method1-APE",
    "Method2",
    "Method2-APE",
    "Best",
    "Iterative-APE-best",
    "Sum-best",
    "Trend",
]
x_label = "Medical Tests"
y_label = "Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the original image's dimensions
plt.figure(figsize=(10, 4))

# Bar width
barWidth = 0.1

# Set position of bar on X axis
r1 = np.arange(len(scores_method1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]
r6 = [x + barWidth for x in r5]
r7 = [x + barWidth for x in r6]

# Make the plot
plt.bar(
    r1,
    scores_method1,
    color="#66c2a5",
    width=barWidth,
    edgecolor="white",
    label=labels[0],
)
plt.bar(
    r2,
    scores_method1_APE,
    color="#fc8d62",
    width=barWidth,
    edgecolor="white",
    label=labels[1],
    hatch="\\",
)
plt.bar(
    r3,
    scores_method2,
    color="#8da0cb",
    width=barWidth,
    edgecolor="white",
    label=labels[2],
)
plt.bar(
    r4,
    scores_method2_APE,
    color="#e78ac3",
    width=barWidth,
    edgecolor="white",
    label=labels[3],
    hatch="\\",
)
plt.bar(
    r5,
    scores_best,
    color="#a6d854",
    width=barWidth,
    edgecolor="white",
    label=labels[4],
)
plt.bar(
    r6,
    scores_iterative_best,
    color="#ffd92f",
    width=barWidth,
    edgecolor="white",
    label=labels[5],
)
plt.bar(
    r7,
    scores_sum_best,
    color="#e5c494",
    width=barWidth,
    edgecolor="white",
    label=labels[6],
)

# Add trend line
plt.plot(
    r1, 
    trend, 
    color="gray", 
    marker="o", 
    linestyle="--", 
    linewidth=2, 
    markersize=6, 
    label=labels[7]
)

# Add xticks on the middle of the group bars
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.xticks([r + barWidth * 3 for r in range(len(scores_method1))], tasks)
plt.ylim(0.3, 0.9)
plt.yticks([0.4, 0.5, 0.6, 0.7, 0.8, 0.9])

# Create legend & Show graphic
plt.title(title)
plt.legend(loc="upper center", ncol=4)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_68.pdf", bbox_inches="tight")
