
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the psychology domain (e.g., stress levels)
stress_levels_control = np.random.normal(50, 10, 1000)  # Control group stress levels
stress_levels_experiment = np.random.normal(45, 15, 1000)  # Experimental group stress levels

min_bin = min(min(stress_levels_control), min(stress_levels_experiment))
max_bin = max(max(stress_levels_control), max(stress_levels_experiment))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Control Group", "Experimental Group"]
legend_title = "Group"
title = "Distribution of Stress Levels"
xlabel = "Stress Level Score"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_control, bins_control, _ = plt.hist(
    stress_levels_control,
    bins=bins,
    color="#8ecae6",
    alpha=0.7,
    label=labels[0],
    edgecolor="black",
    linewidth=1.25,
)
count_experiment, bins_experiment, _ = plt.hist(
    stress_levels_experiment,
    bins=bins,
    alpha=0.7,
    color="#219ebc",
    label=labels[1],
    edgecolor="black",
    linewidth=1.25,
)

# Create line plot on top of the histogram and set edge color
plt.plot(bins_control[:-1] + bin_width * 0.5, count_control, color="#006d77", linestyle='--', linewidth=1.5)
plt.plot(bins_experiment[:-1] + bin_width * 0.5, count_experiment, color="#023047", linestyle=':', linewidth=1.5)

# Add legend, title, and labels
plt.legend(loc="upper left", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_71.pdf", bbox_inches="tight")
