
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
cities = ["New York", "Los Angeles", "Chicago", "Houston", "Phoenix"]
# Generate random plausible data for temperatures and precipitation
np.random.seed(0)
average_temperatures = np.random.uniform(10, 30, size=len(cities))
average_precipitation = np.random.uniform(10, 100, size=len(cities))

# Axes Titles, Labels, and Limits
ax1_title = "Average Monthly Temperatures by City"
ax1_ylabel = "Temperature (°C)"
ax2_title = "Average Monthly Precipitation by City"
ax2_ylabel = "Precipitation (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5))

# Bar chart for Average Monthly Temperatures
ax1.bar(cities, average_temperatures, color="tomato")
ax1.plot(cities, average_temperatures, marker="o", color="darkred")
for i, temp in enumerate(average_temperatures):
    ax1.text(i, temp, f"{temp:.1f}°C", ha="center", va="bottom")
ax1.set_title(ax1_title)
ax1.set_ylabel(ax1_ylabel)
ax1.set_facecolor("#fff3e0")

# Bar chart for Average Monthly Precipitation
ax2.bar(cities, average_precipitation, color="skyblue")
ax2.plot(cities, average_precipitation, marker="o", linestyle="--", color="royalblue")
for i, precip in enumerate(average_precipitation):
    ax2.text(i, precip, f"{precip:.1f} mm", ha="center", va="bottom")
ax2.set_title(ax2_title)
ax2.set_ylabel(ax2_ylabel)
ax2.set_facecolor("#e0f7fa")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_79.pdf", bbox_inches="tight")
