
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
years = np.array([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024])
sustainable_initiative = np.array([5, 10, 20, 35, 50, 70, 80, 90])
traditional_methods = np.array([5, 7, 10, 15, 22, 30, 40, 50])
error = np.array([3])

xlabel = "Year"
ylabel = "Reduction in Carbon Emissions (%)"

errorbar_label = "Traditional Methods"
line_label = "Sustainable Initiative"
title_text = "Reduction in Carbon Emissions Over Time"
legend_loc = "upper left"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(8, 5))  # Adjusting figure size

# Sustainable Initiative
ax.plot(
    years,
    sustainable_initiative,
    marker="s",
    color="#2ca02c",  # Earth tone green
    label=line_label,
    linestyle="--"
)
ax.fill_between(
    years, sustainable_initiative - 3, sustainable_initiative + 3, color="#a1dab4"
)

# Traditional Methods
ax.errorbar(
    years,
    traditional_methods,
    yerr=error,
    fmt="o",
    color="#d95f0e",  # Earth tone brown
    label=errorbar_label,
    capsize=5,
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xlim(2008, 2026)
ax.set_ylim(0, 100)  
ax.legend(loc=legend_loc)
ax.grid(True, linestyle='--', linewidth=0.6)
ax.set_xticks([2010, 2012, 2014, 2016, 2018, 2020, 2022, 2024])
ax.set_title(title_text)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_83.pdf", bbox_inches="tight")
