
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
days = np.arange(1, 8)  # Days of the week
temperature = [21, 23, 20, 25, 22, 24, 23]  # Temperature in Celsius
precipitation = [5, 10, 0, 20, 15, 0, 5]  # Precipitation in mm
days_labels = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"]

# Labels and Title
xlabel = "Days of the Week"
temp_ylabel = "Temperature (°C)"
precip_ylabel = "Precipitation (mm)"
title = "Weekly Weather Data"
legend_labels = ["Temperature", "Precipitation"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plotting Temperature
ax1.plot(days, temperature, "s-", color="#FF5733", label=legend_labels[0], linewidth=2)
ax1.set_xlabel(xlabel)
ax1.set_ylabel(temp_ylabel, color="#FF5733")
ax1.tick_params(axis="y", labelcolor="#FF5733")
ax1.set_ylim([15, 30])
ax1.set_xticks(days)
ax1.set_xticklabels(days_labels)

# Annotating data points for Temperature
for i, txt in enumerate(temperature):
    ax1.annotate(
        f"{txt}°C",
        (days[i], temperature[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        color="#FF5733"
    )

# Create a twin Axes sharing the x-axis for Precipitation
ax2 = ax1.twinx()
ax2.plot(days, precipitation, "o-", color="#1f77b4", label=legend_labels[1], linewidth=2)
ax2.set_ylabel(precip_ylabel, color="#1f77b4")
ax2.tick_params(axis="y", labelcolor="#1f77b4")
ax2.set_ylim([-5, 25])

# Annotating data points for Precipitation
for i, txt in enumerate(precipitation):
    ax2.annotate(
        f"{txt}mm",
        (days[i], precipitation[i]),
        textcoords="offset points",
        xytext=(0, -15),
        ha="center",
        color="#1f77b4"
    )

# Title and Layout
fig.suptitle(title, fontsize=16)
fig.tight_layout()
fig.subplots_adjust(top=0.9)  # Adjust to make room for the title

# Legends
fig.legend(loc="upper center", bbox_to_anchor=(0.5, 1.05), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("CB_87.pdf", bbox_inches="tight")
