
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New dataset: percentage of weekly attendance vs. self-reported spirituality
x = np.random.rand(100) * 0.8 + 0.2
y = np.random.rand(100) * 0.9 + 0.05
line_x = [0.3, 0.5, 0.65, 0.8, 1.0]
line_y = [0.2, 0.35, 0.45, 0.7, 0.9]
scatter_name = "Survey Respondents"
line_name = "Trend Line"
xlabel = "Weekly Attendance %"
ylabel = "Self-Reported Spirituality"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Start with a square Figure
fig = plt.figure(figsize=(6, 6))
gs = fig.add_gridspec(
    2,
    1,
    height_ratios=(1, 4),
    left=0.1,
    right=0.9,
    bottom=0.1,
    top=0.9,
    wspace=0.0,
    hspace=0.0,
)

# Create the Axes
ax = fig.add_subplot(gs[1, 0])
ax_histx = fig.add_subplot(gs[0, 0], sharex=ax)

# Draw the scatter plot and marginals
ax_histx.tick_params(axis="x", labelbottom=False)

# the scatter plot
ax.scatter(x, y, color="#8cb369", edgecolor="white", s=50, label=scatter_name)

# add a line on ax
ax.plot(
    line_x,
    line_y,
    color="#ff6f59",
    linewidth=2,
    linestyle='-',
    marker="o",
    markersize=6,
    label=line_name,
)

# draw a diagonal line
ax.plot([0, 1], [0, 1], color="gray", linestyle="--")

# now determine nice limits by hand
binwidth = 0.05
xymax = max(np.max(np.abs(x)), np.max(np.abs(y)))
lim = (int(xymax / binwidth) + 1) * binwidth
bins = np.arange(0, lim + binwidth, binwidth)
ax_histx.hist(x, bins=bins, color="#b3ffff", edgecolor="black")

# remove the y-axis labels
ax_histx.set_yticks([])

# remove the top, left, and right spines
ax_histx.spines["top"].set_visible(False)
ax_histx.spines["left"].set_visible(False)
ax_histx.spines["right"].set_visible(False)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)

ax.set_xticks([0.00, 0.25, 0.50, 0.75, 1.00])
ax.set_yticks([0.00, 0.25, 0.50, 0.75, 1.00])
ax.set_xlim(-0.05, 1.05)
ax.set_ylim(-0.05, 1.05)

ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_88.pdf", bbox_inches="tight")
