
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the new data for each subplot using random numbers and normal distribution
likes_data = np.random.normal(500, 50, 1000)
comments_data = np.random.normal(300, 30, 1000)
shares_data = np.random.normal(200, 20, 1000)
views_data = np.random.normal(1000, 100, 1000)
titles = ["Likes", "Comments", "Shares", "Views"]
xlabels = ["Number of Likes", "Number of Comments", "Number of Shares", "Number of Views"]
ylabels = ["Frequency", "Frequency", "Frequency", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to a more readable size for presentation
plt.figure(figsize=(12, 10))

# Define the subplot grid with reduced space between subplots
grid = plt.GridSpec(2, 2, wspace=0.4, hspace=0.5)

# Likes subplot
ax_likes = plt.subplot(grid[0, 0])
ax_likes.hist(likes_data, bins=20, color="#ff6f61", edgecolor="black", density=True, linewidth=1)
ax_likes.plot(np.sort(likes_data), norm.pdf(np.sort(likes_data), np.mean(likes_data), np.std(likes_data)),
              color="#4285f4", linewidth=2)
ax_likes.set_title(titles[0])
ax_likes.set_xlabel(xlabels[0])
ax_likes.set_ylabel(ylabels[0])
ax_likes.text(0.7, 0.8, f"$\mu = {np.mean(likes_data):.2f}$\n$\sigma = {np.std(likes_data):.2f}$",
              transform=ax_likes.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# Comments subplot
ax_comments = plt.subplot(grid[0, 1])
ax_comments.hist(comments_data, bins=20, color="#ffafc9", edgecolor="black", density=True, linewidth=1)
ax_comments.plot(np.sort(comments_data), norm.pdf(np.sort(comments_data), np.mean(comments_data), np.std(comments_data)),
                 color="#34a853", linewidth=2)
ax_comments.set_title(titles[1])
ax_comments.set_xlabel(xlabels[1])
ax_comments.set_ylabel(ylabels[1])
ax_comments.text(0.7, 0.8, f"$\mu = {np.mean(comments_data):.2f}$\n$\sigma = {np.std(comments_data):.2f}$",
                 transform=ax_comments.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# Shares subplot
ax_shares = plt.subplot(grid[1, 0])
ax_shares.hist(shares_data, bins=20, color="#b6d7a8", edgecolor="black", density=True, linewidth=1)
ax_shares.plot(np.sort(shares_data), norm.pdf(np.sort(shares_data), np.mean(shares_data), np.std(shares_data)),
               color="#fbbc05", linewidth=2)
ax_shares.set_title(titles[2])
ax_shares.set_xlabel(xlabels[2])
ax_shares.set_ylabel(ylabels[2])
ax_shares.text(0.7, 0.8, f"$\mu = {np.mean(shares_data):.2f}$\n$\sigma = {np.std(shares_data):.2f}$",
               transform=ax_shares.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# Views subplot
ax_views = plt.subplot(grid[1, 1])
ax_views.hist(views_data, bins=20, color="#d9ead3", edgecolor="black", density=True, linewidth=1)
ax_views.plot(np.sort(views_data), norm.pdf(np.sort(views_data), np.mean(views_data), np.std(views_data)),
              color="#ea4335", linewidth=2)
ax_views.set_title(titles[3])
ax_views.set_xlabel(xlabels[3])
ax_views.set_ylabel(ylabels[3])
ax_views.text(0.7, 0.8, f"$\mu = {np.mean(views_data):.2f}$\n$\sigma = {np.std(views_data):.2f}$",
              transform=ax_views.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_96.pdf", bbox_inches="tight")
