
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Import numpy library in Part 2 for data preparation
np.random.seed(0)

# Define the bubble sizes and colors for each task
bubble_sizes = {100: 500, 80: 450, 60: 400, 40: 300, 20: 150, 0: 20}
colors = {0: "#ff9999", 1: "#66b3ff", 2: "#99ff99", 3: "#ffcc99"}
label2idx = {"Cognitive Test (CT)": 0, "Emotional Test (ET)": 1, "Memory Test (MT)": 2, "Behavioral Assessment (BA)": 3}
idx2label = {v: k for k, v in label2idx.items()}

data = {
    "Group A": {
        "Cognitive Test (CT)": [60, 60, 60, 60],
        "Emotional Test (ET)": [60, 60, 60, 60],
        "Memory Test (MT)": [60, 60, 60, 60],
        "Behavioral Assessment (BA)": [60, 60, 60, 60],
    },
    "Group B": {
        "Cognitive Test (CT)": [0, 0, 0, 80],
        "Emotional Test (ET)": [0, 0, 80, 0],
        "Memory Test (MT)": [0, 80, 0, 0],
        "Behavioral Assessment (BA)": [80, 0, 0, 0],
    },
    "Group C": {
        "Cognitive Test (CT)": [20, 40, 60, 100],
        "Emotional Test (ET)": [20, 40, 60, 100],
        "Memory Test (MT)": [20, 40, 60, 100],
        "Behavioral Assessment (BA)": [20, 40, 60, 100],
    },
    "Group D": {
        "Cognitive Test (CT)": [0, 0, 0, 80],
        "Emotional Test (ET)": [0, 0, 80, 0],
        "Memory Test (MT)": [0, 40, 0, 0],
        "Behavioral Assessment (BA)": [20, 0, 0, 0],
    },
}

title = "Psychological Assessment"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the subplots
fig, axs = plt.subplots(1, 4, figsize=(10, 3), sharey=True)

# Loop through each subplot and plot the data
for i, (title, tasks) in enumerate(data.items()):
    ax = axs[i % 4]
    ax.set_title(title)

    for task, values in tasks.items():
        ax.scatter(
            x=range(len(values)),
            y=[label2idx[task]] * len(values),
            s=[bubble_sizes[_] for _ in values],
            c=colors[label2idx[task]],
            label=task,
            alpha=0.6,
            edgecolors="w",
            linewidth=0.5,
            marker="o" if task == "Cognitive Test (CT)" else "s" if task == "Emotional Test (ET)" else "D" if task == "Memory Test (MT)" else "P"
        )
        for j, v in enumerate(values):
            ax.text(j, label2idx[task], str(v), ha="center", va="center", fontsize=8)
    ax.set_xticks(range(len(values)))
    ax.set_xticklabels([i for i in range(len(values))])
    ax.set_xlim(-0.5, len(values) - 0.5)
    ax.set_ylim(-0.5, len(label2idx) - 0.5)
    ax.set_yticks(range(len(label2idx)))
    ax.set_yticklabels([idx2label[idx] for idx in range(len(label2idx))])
    ax.set_xlabel("Participant")

# Add the legend
handles, labels = axs[0].get_legend_handles_labels()

# set the title 'Psychological Assessment' of legend to the left of the legend
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=4,
    markerscale=0.5,
    fontsize="small",
    bbox_to_anchor=(0.5, -0.1),
    title=title,
    title_fontsize="small",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("HR_28.pdf", bbox_inches="tight")
